<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login</title>
  <style>
    body {
      background-color: #a8b5d9;
      font-family: Arial, sans-serif;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }
    .login-container {
      background-color: #fff;
      padding: 40px;
      border-radius: 12px;
      width: 350px;
      box-shadow: 0 0 20px rgba(0,0,0,0.2);
      text-align: center;
    }
    .login-container h2 {
      margin-bottom: 20px;
      color: #3a4a8f;
    }
    .input-group {
      margin-bottom: 15px;
      text-align: left;
    }
    .input-group label {
      display: block;
      font-size: 14px;
      color: #3a4a8f;
      margin-bottom: 5px;
    }
    .input-group input {
      width: 100%;
      padding: 10px;
      border: 1px solid #ccc;
      border-radius: 6px;
    }
    .actions {
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-size: 13px;
    }
    .actions a {
      color: #3a4a8f;
      text-decoration: none;
    }
    .btn {
      width: 100%;
      background-color: #3a4a8f;
      color: white;
      border: none;
      padding: 10px;
      border-radius: 6px;
      cursor: pointer;
      font-size: 16px;
      margin-top: 15px;
    }
    .btn:hover {
      background-color: #2c3e91;
    }
    .register {
      margin-top: 15px;
      font-size: 14px;
    }
    .register a {
      color: #3a4a8f;
      text-decoration: none;
      font-weight: bold;
    }
  </style>
</head>
<body>

  <div class="login-container">
    <h2>Sign In</h2>
    <!-- form action diganti dengan javascript agar langsung ke dashboard -->
    <form onsubmit="goToDashboard(event)">
      <div class="input-group">
        <label for="email">Email</label>
        <input type="email" id="email" name="email" required placeholder="Enter your email">
      </div>
      <div class="input-group">
        <label for="password">Password</label>
        <input type="password" id="password" name="password" required placeholder="Enter your password">
      </div>

      <div class="actions">
        <label><input type="checkbox" name="remember"> Remember me</label>
        <a href="lupa.php">Forgot password?</a>
      </div>

      <button type="submit" class="btn">Login</button>

      <div class="register">
        Not registered? <a href="daftar.php">Create an account</a>
      </div>
    </form>
  </div>

  <script>
    function goToDashboard(event) {
      event.preventDefault(); // mencegah reload form
      window.location.href = "dashboard.php"; // langsung ke dashboard
    }
  </script>

</body>
</html>
